#define INITGUID   /* required to get the GUIDs */
#define COBJMACROS /* get macros for interface methods */

#include <windows.h>
#include <ole2.h>
#include <stdio.h>
#include "../server/IZTest.h"

int
main (int argc, char** argv)
{
    IZTest* pZTest = NULL;
    HRESULT hr = S_OK;
    const char* msg1 = "This is a test message";
    char* msg = 0;
    
    if (argc > 1)
        msg1 = argv[1];

    msg = (char*)malloc(sizeof(char) * strlen(msg1));
    if (msg == NULL)
    {
        fprintf(stderr, "Out of memory\n");
        exit(1);
    }
    strcpy(msg, msg1);
    
    hr = CoInitialize(0);
    if (FAILED(hr))
    {
        fprintf(stderr, "Failed to initialize COM libraries\n");
        exit((int)hr);
    }
    
    hr = CoCreateInstance(&CLSID_ZTest, NULL, CLSCTX_ALL,
                          &IID_IZTest, (LPVOID)&pZTest);
    if (SUCCEEDED(hr))
    {
#ifdef COBJMACROS
        hr = IZTest_Message(pZTest, msg);
        IUnknown_Release(pZTest);
#else
        hr = pZTest->lpVtbl->Message(msg);
        pZTest->lpVtbl->Release(pZTest);
#endif
    }
    else
    {
        fprintf(stderr, "Failed to create an instance of ZTest. hr=0x%08lX\n", hr);
    }
    
    CoUninitialize();
    
    free(msg);
    
    return (int)hr;
}

/*
 * Local variables:
 *   mode: c
 *   c-file-style: "stroustrup"
 *   indent-tabs-mode: nil
 * End:
 */
