// exports.cpp - Copyright (C) 2000 Pat Thoyts <pat@zsplat.freeserve.co.uk>
//
// DLL functions for the ZTest COM object.
//
// @(#)$Id: exports.cpp,v 1.1.1.1 2000/11/20 02:10:46 pat Exp $

#include <windows.h>
#include <ole2.h>
#include <tchar.h>

#include "ZTest.h"
#include "ClassFactory.h"

HMODULE               g_hModule;
CClassFactory<CZTest> g_ZTestFactory;

EXTERN_C BOOL APIENTRY 
DllMain(HANDLE hModule, DWORD dwReason, void* lpReserved)
{
    switch(dwReason)
    {
    case DLL_PROCESS_ATTACH:
        g_hModule = hModule;
        break;
    case DLL_PROCESS_DETACH:
        break;
    }
    
    return TRUE;
}

EXTERN_C STDAPI 
DllGetClassObject(REFCLSID rclsid, REFIID riid, void** ppv)
{
    *ppv = 0;
    if (rclsid == CLSID_ZTest)
	return g_ZTestFactory.QueryInterface(riid, ppv);
    else
	return CLASS_E_CLASSNOTAVAILABLE;
}

EXTERN_C STDAPI
DllCanUnloadNow()
{
    if (g_ZTestFactory.CanUnloadNow())
	return S_OK;
    else
	return S_FALSE;
}

// Deal with updating the registry when called by regsvr32.

EXTERN_C STDAPI
DllRegisterServer(void)
{
    HKEY hKeyClsid, hKeyProgID, hKeyClass, hKeyInterface, hKeyIZTest;
    LPCTSTR szClsid  = _T("{2BC4CD80-5C3F-11d4-B3DD-98B3EB449417}");
    LPCTSTR szIID    = _T("{2BC4CD81-5C3F-11d4-B3DD-98B3EB449417}");
    LPCTSTR szIZTest = _T("IZTest");
    LPCTSTR szCoClass= _T("ZTest GNU Compiler Sample COM code.");
    LPCTSTR szProgID = _T("ZSplat.ZTest");

    LONG cbFileName = MAX_PATH;
    LPTSTR szFileName = new TCHAR[cbFileName];
    if (szFileName == 0)
        return E_OUTOFMEMORY;

    ZeroMemory(szFileName, sizeof(TCHAR) * cbFileName);
    
    RegOpenKey(HKEY_CLASSES_ROOT, "CLSID", &hKeyClsid);
    RegCreateKey(hKeyClsid, szClsid, &hKeyClass);
    cbFileName = GetModuleFileName(g_hModule, szFileName, cbFileName);
    RegSetValue(hKeyClass, _T("InProcServer32"), REG_SZ, szFileName, cbFileName);
    RegSetValue(hKeyClass, 0, REG_SZ, szCoClass, _tcslen(szCoClass));
    RegSetValue(hKeyClass, _T("ProgID"), REG_SZ, szProgID, _tcslen(szProgID));
    RegSetValue(hKeyClass, _T("VersionIndependentProgID"),
                REG_SZ, szProgID, _tcslen(szProgID));
    
    RegCreateKey(HKEY_CLASSES_ROOT, szProgID, &hKeyProgID);
    RegSetValue(hKeyProgID, _T("Clsid"), REG_SZ, szClsid, _tcslen(szClsid));
    
    RegOpenKey(HKEY_CLASSES_ROOT, _T("Interface"), &hKeyInterface);
    RegCreateKey(hKeyInterface, szIID, &hKeyIZTest);
    RegSetValue(hKeyIZTest, 0, REG_SZ, szIZTest, _tcslen(szIZTest));

    RegCloseKey(hKeyProgID);
    RegCloseKey(hKeyClass);
    RegCloseKey(hKeyIZTest);
    RegCloseKey(hKeyInterface);
    RegCloseKey(hKeyClsid);
    
    return S_OK;
}

// Should remove entries from the registry here - maybe one day :)

EXTERN_C STDAPI
DllUnregisterServer(void)
{
    return S_FALSE;
}

// Local variables:
//   mode: c++
//   indent-tabs-mode: nil
//   c-file-style: "stroustrup"
// End:
