# $Id: draw_filtered_message.tcl,v 1.2 2005/10/20 21:32:14 pat Exp $
#
# This does the same job and draw_normal_message but is capable of filtering
# the extra nicks generated by the various bridges used in the tclers chats.
# Namely ircbridge and ijbridge.
#
# Includes support for nick_colors.tcl (now incorporated into tkabber proper)
# and also supports the tclers chat embedded color.
#
# Originally by Steve Redler.
# Modified by Pat Thoyts.

namespace eval tclchat {
    hook::add draw_message_hook [namespace current]::draw_filtered_message 79
}

proc tclchat::draw_filtered_message {chatid from type body x} {
    variable options
    set connid [chat::get_connid $chatid]

    if {[chat::is_our_jid $chatid $from]} {
        set tag me
    } else {
        set tag they
    }

    set chatw [chat::chat_win $chatid]
    set nick [chat::get_nick $connid $from $type]
    
    $chatw mark set MSGLEFT "end - 1 char"
    $chatw mark gravity MSGLEFT left
    
    # Filter out nicks.
    if {$nick == "ijchain" || [string match "*bridge" $nick]} {
        set e [string first ">" $body]
        set nick [string range $body 0 $e]
        set body [string range $body [incr e] end]
        $chatw insert end $nick irc
        
        # Update userlist on "nick left" messages
        if {[string first "***" $body] == 0 && [llength $body] == 3 } {
            set nick [lindex $body 1]
            set nickid "[lindex $chatid 1]/$nick"
            if {[lindex $body 2] == "left"} {
                debugmsg chat "Handle \"$nick\" left message."
                #set ::grouproster(status,$chatid,$nickid) unavailable
                
                set deluser [lsearch $::grouproster(users,$chatid) $nickid]
                if {$deluser >= 0} {
                    debugmsg chat "$nick left"
                    unset ::grouproster(status,$chatid,$nickid)
                    set ::grouproster(users,$chatid) \
                        [lreplace $::grouproster(users,$chatid) \
                             $deluser $deluser]
                    #chat::redraw_roster_after_idle $chatid
                    set nick ""
                    chat::redraw_roster_after_idle $chatid
                }
            }
        }
        
        #this handles "nick entered" & found nicks in chat backlog
        set nick [string map {< "" > "" \{ "" \} ""} $nick]
        set nickid "[lindex $chatid 1]/$nick"
        if {[string first $nickid $::grouproster(users,$chatid)] == -1 && $nick != ""} {
            set ::grouproster(status,$chatid,$nickid) available
            #  jid_to_tag $nickid
            #set ::roster::roster(cached_category_and_subtype,1,$nickid) {user client}
            lappend ::grouproster(users,$chatid)  $nickid
            chat::redraw_roster_after_idle $chatid
        }
    } else {
        #next line is orig
        $chatw insert end < $tag $nick $tag > $tag " "
        if {[info exists options(use_tkchat_colors)] \
                && $options(use_tkchat_colors)} {
            check_color $nick $x
        }
    }
    #sriv end
    set cw [chat::winid $chatid]
    if {[cequal $type groupchat]} {
        set myjid [chat::our_jid $chatid]
        set mynick [chat::get_nick $connid $myjid $type]
        
	lassign [check_message $mynick $body] mymessage mylist
	if {$mymessage} {
	    set win [::chat::chat_win $chatid]
	    set ind 0
	    foreach {i1 i2} $mylist {
		chat::add_emoteiconed_text $win [crange $body $ind [expr {$i1 - 1}]] ""
		$chatw insert end [crange $body $i1 [expr {$i2 - 1}]] me
		set ind $i2
	    }
	    chat::add_emoteiconed_text $win [crange $body $ind end] ""
	    tab_set_updated $cw 1 mesg_to_user
	} else {
	    chat::add_emoteiconed_text [::chat::chat_win $chatid] $body ""
	    tab_set_updated $cw 1 message
	}
    } else {
        chat::add_emoteiconed_text [::chat::chat_win $chatid] $body ""
        tab_set_updated $cw 1 mesg_to_user
    }
    
    $chatw tag add NICK-$nick MSGLEFT "end - 1 char"

    return stop
}

# tclchat::check_color --
#
#	The tclers chat client 'tkchat' likes to embed the users choice of
#	color into the 'x' elements of each jabber message. In this procedure
#	we check that our idea of their color agrees. If not we'll update
#	and refresh.
#
proc tclchat::check_color {nick x} {
    foreach node $x {
        jlib::wrapper:splitxml $node tag attr isempty body children
        if {[cequal [jlib::wrapper:getattr $attr xmlns] "urn:tkchat:chat"]} {
            set color [string trim [jlib::wrapper:getattr $attr "color"] "#"]
            if {[string length $color] > 0} {
                set orig [::plugins::nickcolors::get_nick_color $nick]
                debugmsg chat "Checking color for $nick ('$orig' eq '#$color')"
                if {![cequal "$orig" "#$color"]} {
                    set ::plugins::nickcolors::NickColors($nick) "#$color"
                    ::plugins::nickcolors::change_options
                }
            }
        }
    }
    
}