# Trivial application-direct URL for "/hello"
# The URLs under /hello are implemented by procedures that begin with "::hello::"

package require md5

namespace eval ::webchat {
    variable JID          webchat.tclers.tk
    variable JabberServer localhost
    variable JabberPort   5347
    variable Secret       heelgeheim
    variable chatroom     test@tach.tclers.tk
}

Url_PrefixRemove  /jabber/
Direct_Url        /jabber          ::webchat::
Url_PrefixInstall /jabber/messages ::webchat::messages

set script [file normalize [info script]]
while {[file type $script] eq "link"} {
    set script [file readlink $script]
}
set dir [file dirname $script]
while {[file type $dir] eq "link"} {
    set dir [file readlink $dir]
    puts $dir
}
lappend auto_path /home/jabber/tcl-libs

source $dir/wrapper.tcl
source $dir/jcp.tcl
package require xmppd::jcp
package require html

namespace eval ::webchat {
    variable c
    if {![info exists c]} {
	xmppd::jcp::configure \
	    -component $JID \
	    -secret $Secret \
	    -handler [namespace current]::jabberHandler \
	    -loglevel debug
	set c [xmppd::jcp::create $JabberServer $JabberPort]
    }
}

proc Doc_application/x-tcl {path suffix sock} {
    return [Httpd_ReturnFile $sock "text/plain; charset=UTF-8" $path]
}

proc ::webchat::jabberHandler {type attributes close value children} {

    array set a {from {} to {}}
    array set a $attributes

    switch -exact -- $type {
        message {
            foreach child $children {
                set elt [wrapper::gettag $child]
                if {$elt eq "body"} {
                    lappend body [wrapper::getcdata $child]
                }
            }
            puts "MESSAGE: $a(to) $a(from) $body"
	    regexp {[^/]+$} $a(from) fromnick
            # message $a(to) $a(from) [join $body "\n"]
	    set body [join $body "\n"]
	    if {$body ne ""} {
		set map [list \n <br>\n & "&amp;" < "&lt;" > "&gt;"]
		set body [string map $map $body]
		toall "<tr><td valign=top>$fromnick:</td><td>$body</td></tr>"
	    }
        }
        presence {
            puts "PRESENCE: $a(to) $a(from)"
            # presence $a(to) $a(from)
        }
        
        default {
	    return ; # ignore
	    puts "[string toupper $type]:"
            puts "attributes: $attributes"
            puts "close:      $close"
            puts "value:      $value"
            puts "children:   $children"
        }
    }
}

mypage::contents {}
proc ::webchat:: {args} {
    set html [mypage::header "Welcome to the Tcl'ers Web Chat!"]
    append html {
	<br>
	If you jave a jabber account on all.tclers.tk, enter your username and
	password here.<br>For guest access enter only a nickname.
	<table>
	<form method=post action="jabber/main">
	<tr><td>Username:</td><td><input type=text name=user></td></tr>
	<tr><td>Password:</td><td><input type=password name=pass></td></tr>
	<tr><td>Nickname:</td><td><input type=text name=nick></td></tr>
	<tr><td colspan=2 align=right><input type=submit value=Login></td></tr>
	</table>
	</form>
	<br>
    }
    append html [mypage::footer]
    return $html
}

proc ::webchat::/logout {sid} {
    variable state
    variable JID
    variable chatroom

    presence $nick@$JID/webchat $chatroom/$nick unavailable
    catch { unset state(socket) }
    Redirect_Self /jabber
    return
}

proc ::webchat::messages {sock suffix} {
    array set q [ncgi::nvlist]

    HttpdRespondHeader $sock "text/html; charset=utf-8" 1 ""
    puts $sock "Cache-Control: no-cache"
    puts $sock "Transfer-Encoding: chunked"
    puts $sock ""
    fconfigure $sock -buffering none -encoding utf-8
    fileevent $sock readable [list ::webchat::Close $sock]

    if {![info exists q(sid)]} {
	sendChunk $sock {
	    <html><body>Error: session id missing!</body></html>
	}
	Close $sock
    } elseif {[session::isvalid $q(sid)]} {
	sendChunk $sock {
	    <html><body>Error: \"$q(sid)\" is not a valid session id!</body></html>
	}
	Close $sock
    } else {
	session::setvar $q(sid) sock $sock
	sendChunk $sock {
	    <html><body><table>
	    <tr><td colspan=2>Connected: $sock [fconfigure $sock -peername]</td></tr>
	}
    }
}

proc ::webchat::sendChunk {sock chunk} {
    set chunk [uplevel 1 [list subst $chunk]]
    puts -nonewline $sock [format "%x\r\n%s\r\n" \
			       [string bytelength $chunk] $chunk]
}

proc ::webchat::tonick {nick msg} {
    variable state
    # fixme
}

proc ::webchat::toall {msg} {
    variable state
    foreach sock [array names state] {
        if {[catch {sendChunk $sock $msg}]} {
            Close $sock
        }
    }
}

proc ::webchat::Close {sock} {
    variable state
    catch {close $sock}
    catch {unset state($sock)}
    #toall "<b>* $sock closed!</b><br>"
}

proc ::webchat::/users {args} {
	return "Users Online"
}

proc ::webchat::/input {sid msg args} {
    
    variable JID
    variable chatroom

    if {![session::isvalid $sid]} {
	return "<HTML><BODY>\"$session\" is not a valid session ID!</body></html>"
    }
    set msg [string trim $msg]
    set fromnick [session::getvar $sid nick]
    if {[regexp {/msg +([^[:space:]]+) +(.*)} $msg -> tonick msg]} {
	message $chatroom/$fromnick $chatroom/$tonick $msg chat
    } elseif {$msg ne ""} {
	message $chatroom/$fromnick $chatroom $msg groupchat
    }
    return [subst -nocommands -nobackslashes {
	<HTML>
	<BODY BGColor=#ffffff>
	<FORM METHOD="POST"
	      ACTION="input"
              enctype="multipart/form-data"
              accept-charset="UTF-8">
	<INPUT SIZE="60" NAME="msg">
	<INPUT TYPE=SUBMIT VALUE="post">
	<INPUT TYPE=HIDDEN NAME="sid" VALUE="$sid">
	<!--
	<SELECT MAXLENGTH=2 NAME="msg_to">
		<OPTION SELECTED VALUE="">to all users</A>
		<OPTION  VALUE="rmax">rmax</A>
	</SELECT>
	-->
	<a href="logout?sid=$sid" target="_parent">logout</a>
	</FORM>
	<SCRIPT LANGUAGE="javascript">
	<!--
		document.forms[0].msg.focus();
	//-->
	</SCRIPT>
	</BODY>
	</HTML>
    }]
}

proc ::webchat::/main {user pass nick args} {
    variable JID
    variable chatroom
    variable users
    variable nicks
    
    set sid [session::create]
    session setvar $sid user $user
    session setvar $sid nick $nick
    set users($user) $sid
    set nicks($nick) $sid

    presence $nick@$JID/webchat $chatroom/$nick
    return [subst -nocommands -nobackslashes {
	<HTML><HEAD><TITLE>The Tcl'ers Chat</TITLE></HEAD>
	 <FRAMESET ROWS="*,60" BORDER=0 FRAMEBORDER=0 FRAMESPACING=0>
	  <FRAMESET COLS="*,150" BORDER=0 FRAMEBORDER=0 FRAMESPACING=0>
	   <FRAME NAME="messages" SRC="messages?sid=$sid">
	    <FRAME SRC="users">
	   </FRAMESET>
	  <FRAME SRC="input?$sid=$sid" scrolling=no>
	</FRAMESET>
	</HTML>
    }]
}

proc ::webchat::message {from to body {type chat}} {
    variable c
    xmppd::jcp::route $c \
        [wrapper::createxml \
             [list message \
                  [list xmlns jabber:client \
                       type $type from $from to $to] 0 {} \
                  [list [list body [list xmlns jabber:client] 0 $body {}]]]]
    return
}

proc ::webchat::presence {from to {type available}} {
    variable c
    xmppd::jcp::route $c \
        [wrapper::createxml \
             [list presence \
                  [list from $from to $to type $type xmlns jabber:client] 1]]
    return
}


namespace eval session {
    variable seed [clock clicks]
    proc newid {} {
	variable seed
	set seed [expr 30903*($seed&65535)+($seed>>16)]
	return [md5::md5 -hex [format %.4x [expr int(32767*($seed & 65535)/65535.0)]]]
    }
    proc valid {id} {
	if {![exists]} {
	    return -code error "\"$id\" is not a valid session id"
	}
    }
    proc create {{id ""}} {
	if {$id eq ""} {
	    set id [newid]
	}
	namespace eval $id ""
	touch $id
	return $id
    }
    proc destroy {id} {
	valid $id
	namespace delete $id
    }
    proc touch {id} {
	valid $id
	set "[set id]::_time" [clock seconds]
    }
    proc setvar {id var value} {
	valid $id
	touch $id
	set "[set id]::[set variable]" [set value]
    }
    proc getvar {id variable} {
	valid $id
	touch $id
	set "[set id]::[set variable]"
    }
    proc exists {id} { namespace exists $id }
    proc list {} { namespace children }
}
